#include <windows>
#pragma option push -a1
#include <setupapi>
#pragma option pop
#include <assert>
#include <iostream>
#include <cstring>

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
typedef struct _DEVICE_DATA {
  TCHAR  *HardwareId;
  TCHAR  *Path; // cze symboliczne
  DWORD  DeviceInstance;
} DEVICE_DATA, *PDEVICE_DATA;
//---------------------------------------------------------
int setGetHidDeviceData()
{
    PDEVICE_DATA deviceList;
    DWORD propertyBufferSize = 0;
    char *propertyBuffer = NULL;
    SP_DEVINFO_DATA deviceInfoData;

    HMODULE hHidLib;
    HDEVINFO deviceInfoSet;
    SP_INTERFACE_DEVICE_DATA deviceInterfaceData;
    DWORD  memberIndex = 0;
    GUID classGuid;
    PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
    DWORD requiredSize = 0;
    DWORD deviceInterfaceDetailDataSize = 0;
    DWORD searchMaxDevice = 100; //maksymalna liczba interfejsw urzdze
    bool done = false;

    void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

    hHidLib = LoadLibrary("C:\\Windows\\system32\\HID.DLL");
    if (!hHidLib)
      displayError("Bd doczenia biblioteki HID.DLL.");

    (FARPROC&) HidD_GetHidGuid = GetProcAddress(hHidLib,
                                              "HidD_GetHidGuid");
    if (!HidD_GetHidGuid){
       FreeLibrary(hHidLib);
       displayError("Nie znaleziono identyfikatora GUID.");
    }

    HidD_GetHidGuid (&classGuid);

    deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                                       (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE));

    deviceInterfaceData.cbSize = sizeof(SP_INTERFACE_DEVICE_DATA);

    while(!done) {
       deviceList = new DEVICE_DATA[((memberIndex+1)*sizeof(DEVICE_DATA))];

       for(; memberIndex < searchMaxDevice; memberIndex++) {
          if(SetupDiEnumDeviceInterfaces(deviceInfoSet,0,&classGuid,
                                         memberIndex,&deviceInterfaceData)) {
            SetupDiGetDeviceInterfaceDetail(deviceInfoSet,&deviceInterfaceData,
                                         NULL,0,&deviceInterfaceDetailDataSize,
                                         NULL);
            requiredSize = deviceInterfaceDetailDataSize;
            deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)\
                                new DWORD[deviceInterfaceDetailDataSize];

               if(deviceInterfaceDetailData) {
                  deviceInterfaceDetailData->cbSize=\
                               sizeof(SP_INTERFACE_DEVICE_DETAIL_DATA);
                }
                else {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
                }
                deviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
                if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet,
                           &deviceInterfaceData, deviceInterfaceDetailData,
                           deviceInterfaceDetailDataSize,
                           &requiredSize, &deviceInfoData)) {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
                }

            size_t nLen = strlen(deviceInterfaceDetailData->DevicePath) + 1;
            deviceList[memberIndex].Path = new TCHAR[(nLen*sizeof(TCHAR))];

            strncpy(deviceList[memberIndex].Path,
                              deviceInterfaceDetailData->DevicePath, nLen);

            cout <<"\nDeviceList["<<memberIndex<<"].Path: \n" <<
                    deviceList[memberIndex].Path << endl;

            deviceList[memberIndex].DeviceInstance = deviceInfoData.DevInst;

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                        SPDRP_HARDWAREID, NULL, NULL, 0,
                                        &propertyBufferSize);

            //alokowanie pamici dla bufora danych
            propertyBuffer = new char[(propertyBufferSize*sizeof(TCHAR))];

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                           SPDRP_HARDWAREID,NULL,
                                           propertyBuffer, propertyBufferSize,
                                           NULL);

            deviceList[memberIndex].HardwareId  = propertyBuffer;
            cout <<"\nDeviceList["<<memberIndex<<"].HardwareId: \n" <<
                     deviceList[memberIndex].HardwareId << endl;

            }
            else {
                if(ERROR_NO_MORE_ITEMS == GetLastError()){
                  done = TRUE;
                  break;
                }
            }
            releaseMemory(propertyBuffer);
            releaseMemory(deviceInterfaceDetailData);
            releaseMemory(deviceList[memberIndex].Path);
       }
       releaseMemory(deviceList);
    }
    SetupDiDestroyDeviceInfoList(deviceInfoSet);
    FreeLibrary(hHidLib);
    return memberIndex;
}
//---------------------------------------------------------
int main(){
   cout << setGetHidDeviceData() << endl;
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------
 
